<?php
/**
 * TidePoolUI Bootstrap
 * Enchilada Framework
 */

error_reporting(E_ALL);
ini_set('display_errors', 0);
date_default_timezone_set('UTC');

// Load system configuration
require_once __DIR__ . '/../system/app.conf.php';

// Load autoloader
require_once __DIR__ . '/../system/autoload.inc.php';

// Load settings
if (file_exists(APPLICATION_CONFDIR . 'settings.php')) {
    $SETTINGS = include APPLICATION_CONFDIR . 'settings.php';
} else {
    $SETTINGS = [
        'kafka' => [
            'brokers' => 'kafka01:9092,kafka02:9092,kafka03:9092',
            'topic' => 'tidepool.prod.shares',
            'group_id' => 'tidepoolui-consumer',
        ],
        'api' => [
            'cors_origins' => ['*'],
        ],
    ];
}

// Load local configuration overrides (after $SETTINGS is defined)
@include_once APPLICATION_CONFDIR . 'local.conf.php';

// Initialize Kafka consumer (lazy load)
$KAFKA = null;
