<?php
/**
 * Class Autoloader
 * Enchilada Framework
 */

spl_autoload_register(function ($class) {
    // Check classes directory
    $classFile = APPLICATION_CLASSDIR . strtolower($class) . '.class.php';
    if (file_exists($classFile)) {
        require_once $classFile;
        return;
    }
    
    // Check libraries directory (namespace-based)
    $parts = explode('\\', $class);
    if (count($parts) > 1) {
        $libFile = APPLICATION_LIBDIR . implode(DIRECTORY_SEPARATOR, $parts) . '.php';
        if (file_exists($libFile)) {
            require_once $libFile;
            return;
        }
    }
});

// Load Composer autoloader if available
$composerAutoload = APPLICATION_LIBDIR . 'composer/vendor/autoload.php';
if (file_exists($composerAutoload)) {
    require_once $composerAutoload;
}
