<?php
/**
 * TidePoolUI Settings
 * Copy to local.conf.php and modify as needed
 */

return [
    'app' => [
        'demo_enabled' => false, // Set to false in production
    ],
    'admin' => [
        // Shared secret for admin access (set in local.conf.php)
        // When provided in X-Admin-Secret header, full IP addresses are shown
        'secret' => null,
    ],
    'kafka' => [
        'brokers' => 'kafka01:9092,kafka02:9092,kafka03:9092',
        'topic' => 'tidepool.prod.shares',
        'group_id' => 'tidepoolui-consumer',
        'auto_offset_reset' => 'latest',
    ],
    'api' => [
        'cors_origins' => ['*'],
        'rate_limit' => 100, // requests per minute
    ],
    'cache' => [
        'shares_ttl' => 60,    // seconds to keep shares in memory
        'stats_ttl' => 5,      // seconds to cache statistics
        'worker_ttl' => 900,   // seconds before worker considered offline (15 min)
        // Redis connection (override in local.conf.php for multi-chain)
        // 'redis_host' => '127.0.0.1',
        // 'redis_port' => 6379,
        // 'redis_db' => 0,
    ],
    'date' => [
        'format' => 'c', // RFC 3339/ISO 8601 format
    ],
];
