# Changelog

All notable changes to TidePoolUI will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/).

## [Unreleased]

### Added
- **Redis database selection** via `REDIS_DB` env var (multi-chain on single Redis instance)
- **Consumer env file** (`consumer.env`) replaces individual rc.conf variables

### Changed
- **RC script modernization** — uses rc.subr built-in `status`, `${name}_env_file`, `daemon -u`

## [0.2.0] - 2026-02-09

### Added
- **Configurable API gateway** via Apache SSI (`API_GATEWAY` env var)
  - Chain selector dropdown (replaces pool selector in production)
  - HTMX `configRequest` handler rewrites all API URLs at runtime
  - Dev mode (`./dev.sh`) unaffected — falls back to same-origin `/api/v1`
- **FreeBSD ports** for tidepoolui-frontend, tidepoolui-api, tidepoolui-consumer
- FreeBSD OCI container testing documentation
- **Multi-pool support** for aggregating stats from multiple SeaTidePool instances
  - Consumer tracks `pool_id` from Kafka messages
  - Both aggregate (all pools) and per-pool stats stored in Redis
  - API supports `?pool=<pool_id>` query parameter for filtering
  - New `/api/v1/pools` endpoint lists available pools
- **Hashrate calculation** using EWMA decay (matches SeaTidePool algorithm)
  - Pool-wide hashrate (1m, 5m, 15m, 1h averages)
  - Per-worker hashrate tracking
  - Human-readable formatting (H/s to EH/s)
- PHP rdkafka-based Kafka consumer (`backend/bin/share-consumer.php`)
- Redis-backed ShareStore for persistent data storage
- HTMX + Handlebars client-side templating for real-time UI updates
- Comprehensive documentation in `doc/` folder
- Dark/light theme toggle
- FreeBSD installation runbook (`doc/RUNBOOK_FREEBSD_INSTALL.md`)

### Changed
- Switched from in-memory to Redis for share storage
- Updated API to return data format compatible with Handlebars templates

### Fixed
- HTMX template rendering issues with `{{#each}}` loops
- Worker and shares tables displaying correctly

### Removed
- Linux-based Containerfile and podman-compose.yml (use FreeBSD ports instead)

## [0.1.0] - 2026-01-28

### Added
- Initial release
- REST API with Enchilada framework
- Pool statistics dashboard
- Active workers table
- Recent shares table
- Demo data generation for testing
- Podman containerization support
- Pico CSS styling
