# TidePoolBridge

ZMQ-to-Redis bridge daemon for the TidePool mining platform. Subscribes to bitcoind and SeaTidePool ZMQ PUB sockets and writes real-time network and pool statistics to Redis for consumption by the TidePoolUI API.

## Architecture

```
┌──────────┐     ┌──────────────┐     ┌──────────────┐
│ bitcoind │────→│              │────→│    Redis     │
│  (ZMQ)   │     │ TidePoolBridge│     │  (Valkey)    │
└──────────┘     │              │     └──────────────┘
┌──────────┐     │              │           ↑
│SeaTidePool│───→│              │     ┌─────┴────────┐
│  (ZMQ)   │     └──────────────┘     │  TidePoolUI  │
└──────────┘                          │  API backend  │
                                      └──────────────┘
```

### Data Flow

1. **bitcoind `hashblock`** → bridge receives ZMQ notification → polls `getmininginfo` + `getnetworkhashps` via JSON-RPC → writes to Redis hash `chain:{chain_id}:network`
2. **SeaTidePool `poolstats`** → bridge receives JSON via ZMQ → writes to Redis hash `chain:{chain_id}:poolstats`

## Requirements

- PHP 8.4+
- [pecl-zmq](https://github.com/zeromq/php-zmq) extension
- [pecl-redis](https://pecl.php.net/package/redis) extension
- pcntl extension (for signal handling)
- curl extension (for bitcoind JSON-RPC)

## Installation

```sh
cp config/settings.ini.sample config/settings.ini
# Edit config/settings.ini with your bitcoind RPC credentials and ZMQ endpoints
```

### FreeBSD

```sh
pkg install php84-pecl-zmq php84-pecl-redis php84-curl php84-pcntl
```

The FreeBSD port installs an RC script:

```sh
# Enable in rc.conf
sysrc tidepoolbridge_enable=YES
sysrc tidepoolbridge_conf=/usr/local/etc/tidepoolbridge/settings.ini

# Start
service tidepoolbridge start

# Check health
service tidepoolbridge health
```

## Development

Run directly:

```sh
php bin/zmq-bridge.php
```

Override config path:

```sh
TIDEPOOLBRIDGE_CONF=/path/to/settings.ini php bin/zmq-bridge.php
```

## Redis Keys

| Key | Type | Source | Description |
|-----|------|--------|-------------|
| `chain:{id}:network` | Hash | bitcoind RPC | height, difficulty, nethash, best_block, chain, updated_at |
| `chain:{id}:poolstats` | Hash | SeaTidePool ZMQ | workers, users, hashrate, SPS, best_diff, updated_at |

## License

BSD 3-Clause. See [LICENSE](LICENSE).
