<?php
/**
 * Development router - serves frontend and proxies API requests
 */

$uri = $_SERVER['REQUEST_URI'];
$path = parse_url($uri, PHP_URL_PATH);

// API requests go to the API
if (strpos($path, '/api/') === 0) {
    chdir(__DIR__ . '/backend/api');
    require __DIR__ . '/backend/api/index.php';
    return true;
}

// Static files from frontend
$file = __DIR__ . '/frontend' . $path;
if (is_file($file)) {
    // Set proper MIME type
    $ext = pathinfo($file, PATHINFO_EXTENSION);
    $mimeTypes = [
        'js' => 'application/javascript',
        'css' => 'text/css',
        'html' => 'text/html',
        'json' => 'application/json',
        'png' => 'image/png',
        'jpg' => 'image/jpeg',
        'gif' => 'image/gif',
        'svg' => 'image/svg+xml',
        'ico' => 'image/x-icon',
    ];
    $mime = $mimeTypes[$ext] ?? 'application/octet-stream';
    header("Content-Type: $mime");
    readfile($file);
    return true;
}

// Default to index.html
$file = __DIR__ . '/frontend/index.html';
if (is_file($file)) {
    header('Content-Type: text/html');
    readfile($file);
    return true;
}

http_response_code(404);
echo "Not found";
