<?php
/**
 * TidePoolUI Redis Connection Component
 * Enchilada Framework 3.0
 * 
 * Creates a shared Redis connection from settings.
 * Included by the bootstrap component loader.
 */

use Enchilada\Config\IniConfig;

/**
 * Create a Redis connection from IniConfig settings.
 * 
 * @param  IniConfig|null $settings Application settings (null = defaults)
 * @return Redis                    Connected Redis instance
 * @throws RedisException           If connection fails
 */
function tidepoolui_create_redis(?IniConfig $settings = null): Redis
{
    $redis = new Redis();
    
    $host = getenv('REDIS_HOST') ?: '127.0.0.1';
    $port = (int)(getenv('REDIS_PORT') ?: 6379);
    $db = (int)(getenv('REDIS_DB') ?: 0);
    
    if ($settings) {
        $host = $settings->getString('redis', 'host', $host);
        $port = $settings->getInt('redis', 'port', $port, min: 1, max: 65535);
        $db = $settings->getInt('redis', 'db', $db, min: 0, max: 15);
    }
    
    $redis->connect($host, $port, 2.0); // 2 second connection timeout
    $redis->setOption(Redis::OPT_READ_TIMEOUT, 5); // 5 second read timeout
    
    if ($db > 0) {
        $redis->select($db);
    }
    
    return $redis;
}
