<?php
/**
 * TidePoolUI Development Router
 * For use with PHP built-in server: php -S localhost:8080 router.php
 */

$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);

// API requests go to backend
if (preg_match('#^/api/#', $uri)) {
    // Include backend bootstrap
    require_once __DIR__ . '/../backend/includes/bootstrap.inc.php';
    require_once __DIR__ . '/../backend/api/index.php';
    return true;
}

// Serve static files if they exist
$file = __DIR__ . $uri;
if (is_file($file)) {
    return false; // Let PHP built-in server handle it
}

// Default to index.html
if ($uri === '/' || !is_file($file)) {
    include __DIR__ . '/index.html';
    return true;
}

return false;
