# TidePool Monitor

A modern web UI for monitoring SeaTidePool mining pool shares in real-time via Kafka.

## Architecture

```
┌─────────────────┐     ┌─────────────────┐     ┌─────────────────┐
│   SeaTidePool   │────▶│  Kafka Cluster  │────▶│  TidePoolUI     │
│   (Stratum)     │     │ tidepool.shares │     │  (PHP/HTMX)     │
└─────────────────┘     └─────────────────┘     └─────────────────┘
```

## Tech Stack

- **Backend**: PHP 8.3 (Enchilada Framework pattern)
- **Frontend**: HTMX + Handlebars client-side templates
- **Styling**: Pico CSS (lightweight, classless, modern)
- **Messaging**: Apache Kafka (via php-rdkafka)
- **Container**: Podman/Docker

## Quick Start

### Option 1: PHP Built-in Server (simplest)

```sh
cd frontend
php -S localhost:8080
```

Open http://localhost:8080

### Option 2: Podman (full environment with Kafka support)

```sh
chmod +x dev.sh
./dev.sh start
```

Open http://localhost:8080

## API Endpoints

| Endpoint | Method | Description |
|----------|--------|-------------|
| `/api/v1/shares` | GET | Recent shares (default 50, max 100) |
| `/api/v1/stats` | GET | Pool statistics |
| `/api/v1/workers` | GET | Worker statistics |
| `/api/v1/health` | GET | Health check |
| `/api/v1/demo` | POST | Add demo data (testing) |

### Example Responses

**GET /api/v1/stats**
```json
{
  "success": true,
  "data": {
    "total_shares": 1234,
    "valid_shares": 1200,
    "invalid_shares": 34,
    "workers_seen": 5,
    "acceptance_rate": 97.24,
    "shares_per_minute": 12.5
  }
}
```

## Project Structure

```
TidePoolUI/
├── backend/
│   ├── api/              # REST API endpoints
│   │   └── index.php     # API router
│   ├── classes/          # Business logic
│   │   ├── sharestore.class.php
│   │   └── apiresponse.class.php
│   ├── config/           # Configuration
│   │   └── settings.php
│   ├── includes/         # Bootstrap and components
│   │   └── bootstrap.inc.php
│   └── system/           # Framework core
│       ├── app.conf.php
│       └── autoload.inc.php
├── frontend/
│   ├── index.html        # Main UI (HTMX + Handlebars)
│   ├── css/
│   │   └── app.css       # Custom styles
│   └── js/
│       └── app.js        # Handlebars helpers & app logic
├── Dockerfile            # PHP 8.3 + Apache + rdkafka
├── podman-compose.yml    # Development environment
├── dev.sh                # Helper script
└── README.md
```

## Configuration

Edit `backend/config/settings.php`:

```php
return [
    'kafka' => [
        'brokers' => 'kafka01:9092,kafka02:9092,kafka03:9092',
        'topic' => 'tidepool.prod.shares',
        'group_id' => 'tidepoolui-consumer',
    ],
];
```

## Development

### Adding Demo Data

Click the "Add Demo Data" button in the UI, or:

```sh
curl -X POST http://localhost:8080/api/v1/demo
```

### Theme Toggle

The UI supports light/dark themes. Click the moon/sun icon in the header.

## Future Enhancements

- [ ] Real-time Kafka consumer (SSE or WebSocket)
- [ ] Historical charts (hashrate over time)
- [ ] Worker detail pages
- [ ] Alerting rules
- [ ] Authentication

## Related

- [SeaTidePool](https://github.com/example/seatidepool) - Bitcoin mining pool
- [KAFKA_CONFIGURATION.md](../SeaTidePool/doc/KAFKA_CONFIGURATION.md) - Kafka setup guide
