# FreeBSD Ports for TidePoolUI

TidePoolUI uses the master/slave port pattern for efficient packaging.
All ports share a single distfile from the master port.

## Port Structure

```
www/tidepoolui/           # Master port (meta-port, installs all)
www/tidepoolui-frontend/  # Slave: static web assets
www/tidepoolui-api/       # Slave: PHP REST API
www/tidepoolui-consumer/  # Slave: Kafka consumer daemon
```

TidePoolUI is split into three separate ports for flexible deployment:

| Port | Description | Dependencies |
|------|-------------|--------------|
| `www/tidepoolui-frontend` | Static web frontend | None |
| `www/tidepoolui-api` | PHP REST API | php-redis |
| `www/tidepoolui-consumer` | Kafka consumer daemon | php-redis, pecl-rdkafka |

## Installation

### From Morante Ports Tree

```sh
# Add the Morante ports overlay (if not already configured)
# See: https://git.morante.com/FreeBSD/ports

# Install all components
pkg install tidepoolui-frontend tidepoolui-api tidepoolui-consumer

# Or build from ports
cd /usr/ports/www/tidepoolui-frontend && make install clean
cd /usr/ports/www/tidepoolui-api && make install clean
cd /usr/ports/www/tidepoolui-consumer && make install clean
```

### Typical Deployments

#### Single Server (Development/Testing)

Install all three packages on one machine:

```sh
pkg install tidepoolui-frontend tidepoolui-api tidepoolui-consumer redis kafka
```

#### Production (Separate Servers)

**Web Server (public-facing):**
```sh
pkg install tidepoolui-frontend tidepoolui-api nginx php83
```

**Backend Server (internal):**
```sh
pkg install tidepoolui-consumer redis
```

**Kafka Server (internal):**
```sh
pkg install kafka
```

## Configuration

### Frontend

Installed to: `/usr/local/www/tidepoolui/frontend/`

Configure your web server to serve this directory. The frontend expects
the API to be available at `/api/`.

### API

Installed to: `/usr/local/www/tidepoolui/backend/`

1. Copy sample config:
   ```sh
   cp /usr/local/www/tidepoolui/backend/config/settings.php.sample \
      /usr/local/www/tidepoolui/backend/config/settings.php
   ```

2. Edit `settings.php` to configure Redis connection.

3. Configure PHP-FPM and your web server.

### Consumer

Installed to: `/usr/local/libexec/tidepoolui/`

1. Enable in `/etc/rc.conf`:
   ```sh
   tidepoolui_consumer_enable="YES"
   tidepoolui_consumer_kafka_brokers="kafka.internal:9092"
   tidepoolui_consumer_kafka_topic="tidepool.prod.shares"
   ```

2. Start the service:
   ```sh
   service tidepoolui_consumer start
   ```

3. Check status:
   ```sh
   service tidepoolui_consumer status
   service tidepoolui_consumer health
   ```

## rc.conf Options

| Variable | Default | Description |
|----------|---------|-------------|
| `tidepoolui_consumer_enable` | `NO` | Enable the consumer service |
| `tidepoolui_consumer_user` | `www` | User to run as |
| `tidepoolui_consumer_kafka_brokers` | `localhost:9092` | Kafka broker list |
| `tidepoolui_consumer_kafka_topic` | `tidepool.prod.shares` | Kafka topic |
| `tidepoolui_consumer_kafka_group` | `tidepoolui-consumer` | Consumer group ID |
| `tidepoolui_consumer_health_file` | `/var/run/tidepoolui-consumer.health` | Health check file |
| `tidepoolui_consumer_max_memory` | `128` | Memory limit (MB) |

## Monitoring

The consumer writes a health file that can be monitored:

```sh
# View health status
cat /var/run/tidepoolui-consumer.health

# Example output
{
  "status": "running",
  "pid": 12345,
  "memory_mb": 24.5,
  "metrics": {
    "processed": 10000,
    "valid": 9800,
    "invalid": 200,
    "errors": 0
  }
}
```

Use this with your monitoring system (Nagios, Zabbix, Prometheus, etc.)
to alert on consumer health.
