---
description: Cut a new TidePoolUI release (version bump, tag, tarball, port update, deploy)
---

# TidePoolUI Release Workflow

End-to-end process for cutting a new TidePoolUI release.

## Prerequisites

- All changes committed to master
- `doc/CHANGELOG.md` has entries under `[Unreleased]` (or ready to add)

## Steps

### 1. Finalize CHANGELOG.md

Move `[Unreleased]` entries to a new version section with today's date:

```markdown
## [X.Y.Z] - YYYY-MM-DD

### Changed
...
```

### 2. Bump APPLICATION_VERSION

In `backend/system/app.conf.php`:
```php
define('APPLICATION_VERSION', 'X.Y.Z');
```

### 3. Commit and push

// turbo
```sh
cd /home/admin/Documents/Projects/TidePoolUI
git commit -am "chore: bump to X.Y.Z — summary of changes"
git push origin master
```

### 4. Tag the release

```sh
cd /home/admin/Documents/Projects/TidePoolUI
git tag -a vX.Y.Z -m "Release X.Y.Z - summary"
git push origin vX.Y.Z
```

### 5. Build tarball

// turbo
```sh
cd /home/admin/Documents/Projects/TidePoolUI
VERSION="X.Y.Z"
mkdir -p /tmp/port-build && rm -rf /tmp/port-build/tidepoolui-${VERSION}
git archive --format=tar --prefix=tidepoolui-${VERSION}/ HEAD | tar -xf - -C /tmp/port-build
cd /tmp/port-build && tar -czf tidepoolui-${VERSION}.tar.gz tidepoolui-${VERSION}
echo "TIMESTAMP = $(date +%s)"
echo "SHA256 (tidepoolui-${VERSION}.tar.gz) = $(sha256 -q tidepoolui-${VERSION}.tar.gz)"
echo "SIZE (tidepoolui-${VERSION}.tar.gz) = $(stat -f "%z" tidepoolui-${VERSION}.tar.gz)"
```

Save the TIMESTAMP, SHA256, and SIZE output for step 7.

**IMPORTANT:** The tarball prefix MUST be `tidepoolui-VERSION/` or poudriere will fail.

### 6. Upload tarball to CDN (user manual step)

Upload `/tmp/port-build/tidepoolui-X.Y.Z.tar.gz` to:
```
https://cdn.pacyworld.com/tidepoolui.org/dist/tidepoolui-X.Y.Z.tar.gz
```

Cascade cannot do this — the user must upload manually.

### 7. Update deluxe ports tree

```sh
cd /home/admin/Documents/Ports/deluxe
git checkout master && git pull origin master
git checkout -b tidepoolui-XYZ
```

Update `www/tidepoolui/Makefile`:
```makefile
PORTVERSION=	X.Y.Z
```

**IMPORTANT:** Also bump `www/tidepoolui-frontend/Makefile` AND its `distinfo` —
the frontend port does not use MASTERDIR (unlike api/consumer sub-ports), so it
needs its own version, checksum, and size updated separately:
```makefile
# www/tidepoolui-frontend/Makefile
PORTVERSION=	X.Y.Z
```
Copy the same distinfo values from the master port:
```sh
cp www/tidepoolui/distinfo www/tidepoolui-frontend/distinfo
```

Update `www/tidepoolui/distinfo` with values from step 5:
```
TIMESTAMP = <from step 5>
SHA256 (tidepoolui-X.Y.Z.tar.gz) = <from step 5>
SIZE (tidepoolui-X.Y.Z.tar.gz) = <from step 5>
```

Commit and push:
```sh
git commit -am "www/tidepoolui: update to X.Y.Z"
git push -u origin tidepoolui-XYZ
```

### 8. Create and merge ports PR on Forgejo

Open PR: `https://git.morante.net/freebsd/ports/compare/master...tidepoolui-XYZ`

Merge the PR before triggering builds.

### 9. Build packages with Jenkins

Trigger poudriere bulk builds for both jails:
- Job: `ports/poudriere-bulk`
- `PORTS_TREE`: `deluxe`
- `SET_NAME`: `pool`
- `PKGLIST`: `pool`
- `UPDATE_PORTS`: `true`
- `UPDATE_LISTS`: `true`
- Jail **143amd64** (api01 — runs tidepoolui-api + tidepoolui-consumer)
- Jail **150amd64** (web01 — runs tidepoolui-frontend)

### 10. Deploy to production (user manual step)

**web01** (frontend only — FreeBSD 15.0, tidepoolui jail):
```sh
ssh web01
pkg -j tidepoolui update
pkg -j tidepoolui upgrade tidepoolui-frontend
```

**api01** (API + consumer — FreeBSD 14.2, bitcoin jail):
```sh
ssh api01
pkg -j bitcoin update
pkg -j bitcoin upgrade tidepoolui-api tidepoolui-consumer
service -j bitcoin tidepoolui-consumer restart
```

### 11. Verify

```sh
# Check frontend version
curl -s https://pools.securepayment.cc/api/v1/health | python3 -m json.tool

# Check API health
curl -s https://api.securepayment.cc/bitcoin/v1/health | python3 -m json.tool

# Check consumer is running
ssh api01 "service -j bitcoin tidepoolui-consumer status"
```

## Version Numbering

`Major.Minor.Patch`
- **Patch**: Bug fixes, small changes, privacy/security fixes
- **Minor**: New features, API changes
- **Major**: Breaking changes, architectural overhaul

## Quick Reference

| Item | Location |
|------|----------|
| Source repo | `git@git.morante.com:TidePool/TidePoolUI.git` |
| Ports tree | `/home/admin/Documents/Ports/deluxe/www/tidepoolui*/` |
| CDN | `https://cdn.pacyworld.com/tidepoolui.org/dist/` |
| Jenkins | `https://jenkins.morante.com/job/ports/job/poudriere-bulk/` |
| Frontend | `pools.securepayment.cc` (web01, tidepoolui jail, 150amd64) |
| API | `api.securepayment.cc` (api01, bitcoin jail, 143amd64) |
| Sub-ports | tidepoolui-frontend, tidepoolui-api, tidepoolui-consumer |
