<?php
/**
 * TidePoolUI MariaDB Connection Component
 * Enchilada Framework 3.0
 * 
 * Creates a PDO connection to MariaDB from settings.
 */

use Enchilada\Config\IniConfig;

/**
 * Create a PDO connection to MariaDB from IniConfig settings.
 * 
 * @param  IniConfig|null $settings Application settings (null = defaults)
 * @return PDO                      Connected PDO instance
 * @throws PDOException             If connection fails
 */
function tidepoolui_create_mariadb(?IniConfig $settings = null): PDO
{
    $host = getenv('MARIADB_HOST') ?: '127.0.0.1';
    $port = getenv('MARIADB_PORT') ?: '3306';
    $dbname = getenv('MARIADB_DATABASE') ?: 'miningstats';
    $user = getenv('MARIADB_USER') ?: 'tidepoolui';
    $pass = getenv('MARIADB_PASSWORD') ?: '';
    
    if ($settings) {
        $host = $settings->getString('mariadb', 'host', $host);
        $port = $settings->getString('mariadb', 'port', $port);
        $dbname = $settings->getString('mariadb', 'database', $dbname);
        $user = $settings->getString('mariadb', 'user', $user);
        $pass = $settings->getString('mariadb', 'password', $pass);
    }
    
    $dsn = "mysql:host={$host};port={$port};dbname={$dbname};charset=utf8mb4";
    
    $pdo = new PDO($dsn, $user, $pass, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES => false,
    ]);
    
    return $pdo;
}
