-- TidePoolUI Block & Payment Schema
-- Run against the miningstats MariaDB database

-- Solved blocks (populated by Kafka consumer from tidepool.{env}.blocks topic)
CREATE TABLE IF NOT EXISTS blocks (
    id INT AUTO_INCREMENT PRIMARY KEY,
    height INT NOT NULL,
    hash VARCHAR(64) NOT NULL UNIQUE,
    workername VARCHAR(255) NOT NULL,
    username VARCHAR(255) NOT NULL,
    difficulty DOUBLE NOT NULL,
    pool_id VARCHAR(64) DEFAULT 'default',
    confirmed BOOLEAN DEFAULT FALSE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_username (username),
    INDEX idx_height (height),
    INDEX idx_pool_id (pool_id),
    INDEX idx_confirmed (confirmed)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Payments (future, populated by payment processor)
CREATE TABLE IF NOT EXISTS payments (
    id INT AUTO_INCREMENT PRIMARY KEY,
    block_id INT NOT NULL,
    username VARCHAR(255) NOT NULL,
    amount DECIMAL(20,8) NOT NULL,
    txid VARCHAR(64),
    status ENUM('pending','confirmed','paid','failed') DEFAULT 'pending',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    paid_at TIMESTAMP NULL,
    FOREIGN KEY (block_id) REFERENCES blocks(id),
    INDEX idx_username_status (username, status)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
