# Changelog

All notable changes to TidePoolUI will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/).

## [Unreleased]

## [0.5.0] - 2026-02-16

### Added
- **Pool stats API endpoints** (Phase 3):
  - `GET /api/v1/network` — chain stats from Redis (height, difficulty, nethash)
  - `GET /api/v1/blocks` — solved blocks from MariaDB with user/pool filters
  - `GET /api/v1/user/{address}` — per-user aggregate stats (workers, shares, blocks)
- **PoolStatsStore class**: Reads TidePoolBridge Redis keys (`chain:{id}:network`,
  `chain:{id}:poolstats`) and BlockStore for MariaDB blocks. MariaDB is optional.
- **Poolstats frontend** (`frontend/poolstats/`):
  - `index.html` — pool home: mining instructions, network stats, pool hashrate
  - `blocks.html` — solved blocks table with block explorer links
  - `miners.html` — active workers with hashrates
  - `stats.html` — per-user lookup by address or username
- **Chain detection from URL**: `poolstats.js` reads chain from URL path
  (`/pools/bitcoin/`), fetches `chains.json` from gateway, configures HTMX API
  rewrites. One set of HTML files serves all chains.
- **Enriched `chains.json`** (`config/chains.json`): Per-chain metadata including
  algorithm, stratum_url, reward_percent, block_explorer_url, tx_explorer_url,
  and theme_color. Served at `/mining/` in dev mode (mimics HAProxy in production).
- **Chain-themed CSS**: Poolstats pages use `--poolstats-accent` CSS custom property
  driven by `theme_color` from chains.json. Brand colors ported from old TidePoolStats
  themes (Bitcoin orange, Zetacoin blue). Stat cards, links, and stratum URLs all
  inherit the chain's accent color.
- **Dev router**: `/pools/{chain}/` routes to poolstats pages, `/mining/` serves
  chains.json for local development
- **Kafka blocks consumer**: Consumer now subscribes to both `{prefix}.shares` and
  `{prefix}.blocks` Kafka topics. Block-solved events are persisted to MariaDB via
  new `BlockStore` class. Blocks topic is auto-derived from shares topic name.
- **MariaDB integration**: New `mariadb.inc.php` connection factory with env var
  fallback (same pattern as Redis). Schema in `backend/schema/blocks.sql`.
- **BlockStore class**: MariaDB-backed storage for solved blocks with duplicate
  detection (INSERT IGNORE on block hash). Supports filtering by pool and user.
- **FreeBSD port**: `www/tidepoolui-poolstats` — slave port installing poolstats
  frontend to `/usr/local/www/tidepoolui/poolstats/`.

## [0.4.7] - 2026-02-15

### Changed
- **GeoIP privacy**: Moved IP address and GeoIP location data behind admin lock.
  Non-admin users now see miner software (agent) instead of location. Admin users
  see both the raw IP address and GeoIP location.

## [0.4.6] - 2026-02-14

### Fixed
- **Worker count display**: Dashboard now shows active workers (those with live Redis
  keys) instead of `workers_seen`, a lifetime counter that incremented indefinitely
  as workers disconnected and reconnected.
- **Consumer health file**: RC script now pre-creates the health file with correct
  ownership so the `tidepool` user can write to it after daemon drops privileges.

### Changed
- **Runbook**: Added Redis protected-mode troubleshooting section, updated Kafka
  topic names to `bitcoin.tidepool.shares`.

## [0.4.0] - 2026-02-09

### Added
- **Redis database selection** via `REDIS_DB` env var (multi-chain on single Redis instance)
- **Consumer env file** (`consumer.env`) replaces individual rc.conf variables
- **INI-based settings** via Enchilada `IniConfig` — type-safe configuration with `settings.ini`
- **Redis connection factory** (`includes/redis.inc.php`) — single source of truth for Redis setup
- **External config directory** support via `ENCHILADA_CONF_DIR` env var (for FreeBSD ports)
- **Settings component** (`includes/settings.inc.php`) following Enchilada Framework 3.0 pattern

### Changed
- **RC script modernization** — uses rc.subr built-in `status`, `${name}_env_file`, `daemon -u`
- **Enchilada Framework alignment** — full 3.0 autoloader, standard bootstrap, app.conf.php conventions
- **ShareStore refactored** — accepts Redis via constructor (dependency injection), removed singleton
- **GeoIP refactored** — accepts Redis via constructor (dependency injection), removed singleton
- **API composition root** — wires all dependencies at entry point instead of relying on globals/singletons
- **Consumer reads settings from INI** with env var fallback for backward compatibility
- **DaemonBehavior moved** from `classes/Enchilada/` to `libraries/Enchilada/` (framework-provided code)

### Removed
- Old PHP array config (`config/settings.php`) — replaced by `config/settings.ini`

## [0.2.0] - 2026-02-09

### Added
- **Configurable API gateway** via Apache SSI (`API_GATEWAY` env var)
  - Chain selector dropdown (replaces pool selector in production)
  - HTMX `configRequest` handler rewrites all API URLs at runtime
  - Dev mode (`./dev.sh`) unaffected — falls back to same-origin `/api/v1`
- **FreeBSD ports** for tidepoolui-frontend, tidepoolui-api, tidepoolui-consumer
- FreeBSD OCI container testing documentation
- **Multi-pool support** for aggregating stats from multiple SeaTidePool instances
  - Consumer tracks `pool_id` from Kafka messages
  - Both aggregate (all pools) and per-pool stats stored in Redis
  - API supports `?pool=<pool_id>` query parameter for filtering
  - New `/api/v1/pools` endpoint lists available pools
- **Hashrate calculation** using EWMA decay (matches SeaTidePool algorithm)
  - Pool-wide hashrate (1m, 5m, 15m, 1h averages)
  - Per-worker hashrate tracking
  - Human-readable formatting (H/s to EH/s)
- PHP rdkafka-based Kafka consumer (`backend/bin/share-consumer.php`)
- Redis-backed ShareStore for persistent data storage
- HTMX + Handlebars client-side templating for real-time UI updates
- Comprehensive documentation in `doc/` folder
- Dark/light theme toggle
- FreeBSD installation runbook (`doc/RUNBOOK_FREEBSD_INSTALL.md`)

### Changed
- Switched from in-memory to Redis for share storage
- Updated API to return data format compatible with Handlebars templates

### Fixed
- HTMX template rendering issues with `{{#each}}` loops
- Worker and shares tables displaying correctly

### Removed
- Linux-based Containerfile and podman-compose.yml (use FreeBSD ports instead)

## [0.1.0] - 2026-01-28

### Added
- Initial release
- REST API with Enchilada framework
- Pool statistics dashboard
- Active workers table
- Recent shares table
- Demo data generation for testing
- Podman containerization support
- Pico CSS styling
