/**
 * TidePool Monitor - Handlebars Helpers
 * 
 * Custom helpers for formatting data in templates.
 * Must be loaded after Handlebars and before HTMX processes templates.
 */

Handlebars.registerHelper('truncateHash', function(hash) {
    if (!hash || hash.length < 20) return hash || '';
    return hash.substring(0, 16) + '...';
});

Handlebars.registerHelper('formatDiff', function(diff) {
    if (typeof diff !== 'number') return diff;
    return diff.toFixed(3);
});

Handlebars.registerHelper('formatTime', function(dateString) {
    if (!dateString) return '—';
    var date = new Date(dateString);
    if (isNaN(date.getTime())) return dateString;
    
    var now = new Date();
    var today = new Date(now.getFullYear(), now.getMonth(), now.getDate());
    var dateDay = new Date(date.getFullYear(), date.getMonth(), date.getDate());
    
    var timeStr = date.toLocaleTimeString([], {hour: '2-digit', minute: '2-digit', second: '2-digit'});
    
    if (dateDay.getTime() === today.getTime()) {
        return timeStr;
    } else {
        var dateStr = date.toLocaleDateString([], {month: 'short', day: 'numeric'});
        return dateStr + ' ' + timeStr;
    }
});

Handlebars.registerHelper('relativeTime', function(dateString) {
    if (!dateString) return '';
    var date = new Date(dateString);
    if (isNaN(date.getTime())) return '';
    
    var now = new Date();
    var seconds = Math.floor((now - date) / 1000);
    
    if (seconds < 0) return 'just now';
    if (seconds < 60) return seconds + 's ago';
    if (seconds < 3600) return Math.floor(seconds / 60) + 'm ago';
    if (seconds < 86400) return Math.floor(seconds / 3600) + 'h ago';
    return Math.floor(seconds / 86400) + 'd ago';
});
