<?php
/**
 * Development router - serves frontend and proxies API requests
 */

$uri = $_SERVER['REQUEST_URI'];
$path = parse_url($uri, PHP_URL_PATH);

// Chain discovery endpoint: serves config/chains.json (mimics HAProxy in production)
if ($path === '/mining/' || $path === '/mining') {
    $chainsFile = __DIR__ . '/config/chains.json';
    if (is_file($chainsFile)) {
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: *');
        readfile($chainsFile);
        return true;
    }
}

// API requests go to the API
if (strpos($path, '/api/') === 0) {
    chdir(__DIR__ . '/backend/api');
    require __DIR__ . '/backend/api/index.php';
    return true;
}

// Poolstats pages: /pools/{chain}/ → frontend/poolstats/index.html
// /pools/{chain}/page.html → frontend/poolstats/page.html
if (preg_match('#^/pools/([^/]+)(/(.*))?$#', $path, $m)) {
    $subPath = trim($m[3] ?? '', '/');
    if ($subPath === '') $subPath = 'index.html';
    $poolFile = __DIR__ . '/frontend/poolstats/' . $subPath;
    if (is_file($poolFile)) {
        $ext = pathinfo($poolFile, PATHINFO_EXTENSION);
        $mimeTypes = [
            'js' => 'application/javascript',
            'css' => 'text/css',
            'html' => 'text/html',
            'json' => 'application/json',
        ];
        header('Content-Type: ' . ($mimeTypes[$ext] ?? 'application/octet-stream'));
        readfile($poolFile);
        return true;
    }
}

// Static files from frontend
$file = __DIR__ . '/frontend' . $path;
if (is_file($file)) {
    // Set proper MIME type
    $ext = pathinfo($file, PATHINFO_EXTENSION);
    $mimeTypes = [
        'js' => 'application/javascript',
        'css' => 'text/css',
        'html' => 'text/html',
        'json' => 'application/json',
        'png' => 'image/png',
        'jpg' => 'image/jpeg',
        'gif' => 'image/gif',
        'svg' => 'image/svg+xml',
        'ico' => 'image/x-icon',
    ];
    $mime = $mimeTypes[$ext] ?? 'application/octet-stream';
    header("Content-Type: $mime");
    readfile($file);
    return true;
}

// Default to index.html
$file = __DIR__ . '/frontend/index.html';
if (is_file($file)) {
    header('Content-Type: text/html');
    readfile($file);
    return true;
}

http_response_code(404);
echo "Not found";
